/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-2002 Parametric Technology Corporation.
	All rights reserved.
*/

#include "stdafx.h"
#include "CExample.h"
#include "DlgProxy.h"
#include "CExampleDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCOMExampleDlgAutoProxy

IMPLEMENT_DYNCREATE(CCOMExampleDlgAutoProxy, CCmdTarget)

CCOMExampleDlgAutoProxy::CCOMExampleDlgAutoProxy()
{
	EnableAutomation();
	
	// To keep the application running as long as an OLE automation 
	//	object is active, the constructor calls AfxOleLockApp.
	AfxOleLockApp();

	// Get access to the dialog through the application's
	//  main window pointer.  Set the proxy's internal pointer
	//  to point to the dialog, and set the dialog's back pointer to
	//  this proxy.
	ASSERT (AfxGetApp()->m_pMainWnd != NULL);
	ASSERT_VALID (AfxGetApp()->m_pMainWnd);
	ASSERT_KINDOF(CCOMExampleDlg, AfxGetApp()->m_pMainWnd);
	m_pDialog = (CCOMExampleDlg*) AfxGetApp()->m_pMainWnd;
	m_pDialog->m_pAutoProxy = this;
}

CCOMExampleDlgAutoProxy::~CCOMExampleDlgAutoProxy()
{
	// To terminate the application when all objects created with
	// 	with OLE automation, the destructor calls AfxOleUnlockApp.
	//  Among other things, this will destroy the main dialog
	AfxOleUnlockApp();
}

void CCOMExampleDlgAutoProxy::OnFinalRelease()
{
	// When the last reference for an automation object is released
	// OnFinalRelease is called.  The base class will automatically
	// deletes the object.  Add additional cleanup required for your
	// object before calling the base class.

	CCmdTarget::OnFinalRelease();
}

BEGIN_MESSAGE_MAP(CCOMExampleDlgAutoProxy, CCmdTarget)
	//{{AFX_MSG_MAP(CCOMExampleDlgAutoProxy)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CCOMExampleDlgAutoProxy, CCmdTarget)
	//{{AFX_DISPATCH_MAP(CCOMExampleDlgAutoProxy)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// Note: we add support for IID_ICOMExample to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {DCE1799B-D38A-11D1-A506-0000F8785588}
static const IID IID_ICOMExample =
{ 0xdce1799b, 0xd38a, 0x11d1, { 0xa5, 0x6, 0x0, 0x0, 0xf8, 0x78, 0x55, 0x88 } };

BEGIN_INTERFACE_MAP(CCOMExampleDlgAutoProxy, CCmdTarget)
	INTERFACE_PART(CCOMExampleDlgAutoProxy, IID_ICOMExample, Dispatch)
END_INTERFACE_MAP()

// The IMPLEMENT_OLECREATE2 macro is defined in StdAfx.h of this project
// {DCE17999-D38A-11D1-A506-0000F8785588}
IMPLEMENT_OLECREATE2(CCOMExampleDlgAutoProxy, "COMExample.Application", 0xdce17999, 0xd38a, 0x11d1, 0xa5, 0x6, 0x0, 0x0, 0xf8, 0x78, 0x55, 0x88)

/////////////////////////////////////////////////////////////////////////////
// CCOMExampleDlgAutoProxy message handlers
